<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FIE Burkina - Demande de Financement</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            color: #333;
            background: linear-gradient(135deg, #2e8b57, #228b22);
            min-height: 100vh;
            padding: 2rem 0;
        }

        .container {
            max-width: 1000px;
            margin: 0 auto;
            padding: 0 20px;
        }

        /* Header Banner */
        .header-banner {
            background: white;
            border-radius: 20px 20px 0 0;
            padding: 2rem;
            text-align: center;
            box-shadow: 0 5px 20px rgba(0,0,0,0.1);
        }

        .logo-section {
            display: flex;
            align-items: center;
            justify-content: center;
            gap: 1.5rem;
            margin-bottom: 1rem;
        }

        .fie-logo {
            width: 80px;
            height: 80px;
            background: linear-gradient(135deg, #2e8b57, #228b22);
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            font-size: 1.2rem;
            text-align: center;
            line-height: 1.2;
            box-shadow: 0 4px 15px rgba(46, 139, 87, 0.3);
        }

        .header-title {
            text-align: center;
        }

        .header-title h1 {
            color: #2e8b57;
            font-size: 2rem;
            margin-bottom: 0.5rem;
        }

        .header-title p {
            color: #666;
            font-style: italic;
        }

        .form-title {
            background: linear-gradient(135deg, #2e8b57, #228b22);
            color: white;
            padding: 1.5rem;
            font-size: 1.5rem;
            font-weight: bold;
            text-align: center;
        }

        /* Form Container */
        .form-container {
            background: white;
            border-radius: 0 0 20px 20px;
            box-shadow: 0 10px 40px rgba(0,0,0,0.15);
            overflow: hidden;
        }

        .form-content {
            padding: 2.5rem;
        }

        /* Form Sections */
        .form-section {
            margin-bottom: 2.5rem;
            padding-bottom: 2rem;
            border-bottom: 2px solid #f0f0f0;
        }

        .form-section:last-child {
            border-bottom: none;
        }

        .section-header {
            display: flex;
            align-items: center;
            gap: 0.8rem;
            margin-bottom: 1.5rem;
            padding: 1rem;
            background: linear-gradient(135deg, rgba(46, 139, 87, 0.1), rgba(34, 139, 34, 0.1));
            border-left: 4px solid #2e8b57;
            border-radius: 8px;
        }

        .section-header i {
            font-size: 1.5rem;
            color: #2e8b57;
        }

        .section-header h3 {
            color: #2e8b57;
            font-size: 1.3rem;
            margin: 0;
        }

        /* Form Fields */
        .form-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 1.5rem;
            margin-bottom: 1.5rem;
        }

        .form-row.single {
            grid-template-columns: 1fr;
        }

        .form-row.triple {
            grid-template-columns: 1fr 1fr 1fr;
        }

        .form-group {
            margin-bottom: 1.5rem;
        }

        .form-label {
            display: block;
            margin-bottom: 0.5rem;
            font-weight: 600;
            color: #333;
            font-size: 0.95rem;
        }

        .form-label.required::after {
            content: " *";
            color: #dc3545;
        }

        .form-control, .form-select, .form-textarea {
            width: 100%;
            padding: 0.9rem;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: white;
            font-family: inherit;
        }

        .form-control:focus, .form-select:focus, .form-textarea:focus {
            outline: none;
            border-color: #2e8b57;
            box-shadow: 0 0 0 3px rgba(46, 139, 87, 0.1);
        }

        .form-textarea {
            resize: vertical;
            min-height: 100px;
        }

        .form-textarea.large {
            min-height: 150px;
        }

        /* Checkbox Groups */
        .checkbox-group {
            display: flex;
            flex-direction: column;
            gap: 1rem;
            padding: 1rem;
            background: #f8f9fa;
            border-radius: 10px;
        }

        .checkbox-item {
            display: flex;
            align-items: center;
            gap: 0.8rem;
            padding: 0.8rem;
            background: white;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .checkbox-item:hover {
            border-color: #2e8b57;
            box-shadow: 0 2px 8px rgba(46, 139, 87, 0.1);
        }

        .checkbox-item input[type="checkbox"] {
            width: 20px;
            height: 20px;
            cursor: pointer;
        }

        .checkbox-item label {
            cursor: pointer;
            margin: 0;
            flex: 1;
        }

        /* Results Section */
        .results-grid {
            display: grid;
            gap: 1rem;
        }

        .result-item {
            display: flex;
            align-items: start;
            gap: 0.8rem;
        }

        .result-number {
            min-width: 35px;
            height: 35px;
            background: linear-gradient(135deg, #2e8b57, #228b22);
            color: white;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-top: 0.5rem;
        }

        /* File Upload */
        .file-upload-area {
            border: 2px dashed #ccc;
            border-radius: 10px;
            padding: 2rem;
            text-align: center;
            background: #f8f9fa;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .file-upload-area:hover {
            border-color: #2e8b57;
            background: rgba(46, 139, 87, 0.05);
        }

        .file-upload-area i {
            font-size: 3rem;
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .file-input {
            display: none;
        }

        .file-list {
            margin-top: 1rem;
        }

        .file-item {
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0.8rem;
            background: white;
            border: 1px solid #dee2e6;
            border-radius: 8px;
            margin-bottom: 0.5rem;
        }

        .file-item-info {
            display: flex;
            align-items: center;
            gap: 0.8rem;
        }

        .remove-file {
            background: #dc3545;
            color: white;
            border: none;
            padding: 0.4rem 0.8rem;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .remove-file:hover {
            background: #c82333;
        }

        /* Help Text */
        .help-text {
            font-size: 0.85rem;
            color: #6c757d;
            margin-top: 0.5rem;
            display: flex;
            align-items: center;
            gap: 0.5rem;
        }

        .help-text i {
            color: #2e8b57;
        }

        /* Buttons */
        .form-actions {
            display: flex;
            justify-content: space-between;
            gap: 1rem;
            padding-top: 2rem;
            margin-top: 2rem;
            border-top: 2px solid #f0f0f0;
        }

        .btn {
            padding: 1rem 2.5rem;
            border: none;
            border-radius: 50px;
            font-size: 1.1rem;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.8rem;
            text-decoration: none;
        }

        .btn-primary {
            background: linear-gradient(135deg, #2e8b57, #228b22);
            color: white;
            box-shadow: 0 4px 15px rgba(46, 139, 87, 0.3);
        }

        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 6px 20px rgba(46, 139, 87, 0.4);
        }

        .btn-secondary {
            background: #6c757d;
            color: white;
        }

        .btn-secondary:hover {
            background: #5a6268;
            transform: translateY(-2px);
        }

        .btn-outline {
            background: white;
            color: #2e8b57;
            border: 2px solid #2e8b57;
        }

        .btn-outline:hover {
            background: #2e8b57;
            color: white;
        }

        /* Progress Bar */
        .progress-container {
            background: white;
            padding: 1rem 2rem;
            margin-bottom: 1rem;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }

        .progress-bar {
            height: 8px;
            background: #e9ecef;
            border-radius: 10px;
            overflow: hidden;
            margin-bottom: 0.5rem;
        }

        .progress-fill {
            height: 100%;
            background: linear-gradient(90deg, #2e8b57, #228b22);
            width: 0%;
            transition: width 0.3s ease;
        }

        .progress-text {
            text-align: center;
            font-size: 0.9rem;
            color: #666;
        }

        /* Responsive */
        @media (max-width: 768px) {
            body {
                padding: 1rem 0;
            }

            .form-row {
                grid-template-columns: 1fr;
            }

            .form-row.triple {
                grid-template-columns: 1fr;
            }

            .form-actions {
                flex-direction: column;
            }

            .btn {
                width: 100%;
                justify-content: center;
            }

            .header-title h1 {
                font-size: 1.5rem;
            }

            .fie-logo {
                width: 60px;
                height: 60px;
                font-size: 1rem;
            }
        }

        /* Success Modal */
        .success-modal {
            display: none;
            position: fixed;
            top: 0;
            left: 0;
            right: 0;
            bottom: 0;
            background: rgba(0,0,0,0.8);
            z-index: 9999;
            align-items: center;
            justify-content: center;
        }

        .success-modal.show {
            display: flex;
        }

        .success-content {
            background: white;
            padding: 3rem;
            border-radius: 20px;
            text-align: center;
            max-width: 500px;
            animation: slideUp 0.4s ease;
        }

        @keyframes slideUp {
            from {
                opacity: 0;
                transform: translateY(50px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        .success-icon {
            font-size: 5rem;
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .success-content h2 {
            color: #2e8b57;
            margin-bottom: 1rem;
        }

        .reference-number {
            background: #f8f9fa;
            padding: 1rem;
            border-radius: 10px;
            margin: 1rem 0;
            font-weight: bold;
            color: #2e8b57;
        }
    </style>
</head>
<body>
    <div class="container">
        

        <!-- Form Container -->
        <div class="form-container">
            <!-- Header -->
            <div class="header-banner">
                <div class="logo-section">
                    <div class="fie-logo">
                        FIE<br>
                        <small style="font-size: 0.7em;">BURKINA</small>
                    </div>
                    <div class="header-title">
                        <h1>Fonds d'Intervention pour l'Environnement</h1>
                        <p>L'instrument financier de la politique environnementale du Burkina Faso</p>
                    </div>
                </div>
            </div>

            <div class="form-title">
                <i class="fas fa-file-invoice-dollar"></i> FICHE DE DEMANDE DE FINANCEMENT
            </div>
            <!-- Progress Bar -->
        <div class="progress-container">
            <div class="progress-bar">
                <div class="progress-fill" id="progressFill"></div>
            </div>
            <div class="progress-text" id="progressText">0% complété</div>
        </div>
            <!-- Form Content -->
            <form id="fundingForm" class="form-content my-3">
                <!-- Section 1: Informations de la Structure -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-building"></i>
                        <h3>Informations de la Structure</h3>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label required">Nom de la structure</label>
                            <input type="text" name="nom_structure" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label required">Statut juridique</label>
                            <select name="statut_juridique" class="form-select" required>
                                <option value="">Sélectionnez...</option>
                                <option value="association">Association</option>
                                <option value="ong">ONG</option>
                                <option value="cooperative">Coopérative</option>
                                <option value="entreprise">Entreprise</option>
                                <option value="groupement">Groupement</option>
                                <option value="autre">Autre</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Adresse complète de la structure</label>
                        <textarea name="adresse" class="form-textarea" required></textarea>
                        <div class="help-text" style="margin-top: 1rem;">
                            <i class="fas fa-info-circle"></i>
                            Veuillez joindre le document complet du projet incluant le budget détaillé, le chronogramme et les CV des responsables
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label required">Numéro IFU</label>
                            <input type="text" name="numero_ifu" class="form-control" required>
                        </div>
                        <div class="form-group">
                            <label class="form-label required">Numéro RCCM / Récépissé</label>
                            <input type="text" name="numero_rccm" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label required">Région</label>
                            <select name="region" class="form-select" required>
                                <option value="">Sélectionnez...</option>
                                <option value="Boucle du Mouhoun">Boucle du Mouhoun</option>
                                <option value="Cascades">Cascades</option>
                                <option value="Centre">Centre</option>
                                <option value="Centre-Est">Centre-Est</option>
                                <option value="Centre-Nord">Centre-Nord</option>
                                <option value="Centre-Ouest">Centre-Ouest</option>
                                <option value="Centre-Sud">Centre-Sud</option>
                                <option value="Est">Est</option>
                                <option value="Hauts-Bassins">Hauts-Bassins</option>
                                <option value="Nord">Nord</option>
                                <option value="Plateau-Central">Plateau-Central</option>
                                <option value="Sahel">Sahel</option>
                                <option value="Sud-Ouest">Sud-Ouest</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label class="form-label required">Commune</label>
                            <input type="text" name="commune" class="form-control" required>
                        </div>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Personne habilitée / Fonction</label>
                        <input type="text" name="personne_habilitee" class="form-control" required 
                               placeholder="Ex: Jean OUEDRAOGO / Président">
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            Nom complet et fonction de la personne responsable
                        </div>
                    </div>
                </div>

                <!-- Section 2: Informations sur l'Activité -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-tasks"></i>
                        <h3>Informations sur l'Activité</h3>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Intitulé de l'activité</label>
                        <input type="text" name="intitule_activite" class="form-control" required>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Résumé de l'activité</label>
                        <textarea name="resume_activite" class="form-textarea large" required></textarea>
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            Décrivez brièvement les objectifs, les bénéficiaires et les impacts attendus
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label required">Période de mise en œuvre</label>
                            <input type="text" name="periode_mise_en_oeuvre" class="form-control" required 
                                   placeholder="Ex: Janvier 2025 - Décembre 2025">
                        </div>
                        <div class="form-group">
                            <label class="form-label">Organisations partenaires</label>
                            <input type="text" name="organisations_partenaires" class="form-control" 
                                   placeholder="Ex: ONG XYZ, Association ABC">
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label class="form-label required">Coût total de l'activité (FCFA)</label>
                            <input type="number" name="cout_total" class="form-control" required min="0">
                        </div>
                        <div class="form-group">
                            <label class="form-label required">Montant sollicité (FCFA)</label>
                            <input type="number" name="montant_sollicite" class="form-control" required min="0">
                        </div>
                    </div>
                </div>

                <!-- Section 3: Résultats Attendus -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-chart-line"></i>
                        <h3>Résultats Attendus</h3>
                    </div>

                    <div class="results-grid">
                        <div class="result-item">
                            <div class="result-number">1</div>
                            <div style="flex: 1;">
                                <label class="form-label required">Résultat 1</label>
                                <textarea name="resultat_1" class="form-textarea" required></textarea>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-number">2</div>
                            <div style="flex: 1;">
                                <label class="form-label">Résultat 2</label>
                                <textarea name="resultat_2" class="form-textarea"></textarea>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-number">3</div>
                            <div style="flex: 1;">
                                <label class="form-label">Résultat 3</label>
                                <textarea name="resultat_3" class="form-textarea"></textarea>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-number">4</div>
                            <div style="flex: 1;">
                                <label class="form-label">Résultat 4</label>
                                <textarea name="resultat_4" class="form-textarea"></textarea>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-number">5</div>
                            <div style="flex: 1;">
                                <label class="form-label">Résultat 5</label>
                                <textarea name="resultat_5" class="form-textarea"></textarea>
                            </div>
                        </div>

                        <div class="result-item">
                            <div class="result-number">6</div>
                            <div style="flex: 1;">
                                <label class="form-label">Résultat 6</label>
                                <textarea name="resultat_6" class="form-textarea"></textarea>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Section 4: Guichets du FIE -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-window-restore"></i>
                        <h3>Guichet du FIE Concerné par l'Activité</h3>
                    </div>

                    <div class="checkbox-group">
                        <div class="checkbox-item">
                            <input type="checkbox" name="guichet[]" value="environnement_cadre_vie" id="guichet1">
                            <label for="guichet1">Environnement et cadre de vie</label>
                        </div>

                        <div class="checkbox-item">
                            <input type="checkbox" name="guichet[]" value="risques_catastrophes" id="guichet2">
                            <label for="guichet2">Risques et catastrophes</label>
                        </div>

                        <div class="checkbox-item">
                            <input type="checkbox" name="guichet[]" value="gestion_ressources_sols_eaux" id="guichet3">
                            <label for="guichet3">Gestion des ressources naturelles sols et eaux</label>
                        </div>

                        <div class="checkbox-item">
                            <input type="checkbox" name="guichet[]" value="ressources_forestieres_fauniques" id="guichet4">
                            <label for="guichet4">Gestion durable des ressources forestières et fauniques</label>
                        </div>

                        <div class="checkbox-item">
                            <input type="checkbox" name="guichet[]" value="pratiques_durables_energie" id="guichet5">
                            <label for="guichet5">Promotion de pratiques durables dans les secteurs productifs et l'énergie</label>
                        </div>
                    </div>

                    <div class="help-text" style="margin-top: 1rem;">
                        <i class="fas fa-info-circle"></i>
                        Sélectionnez au moins un guichet correspondant à votre activité
                    </div>
                </div>

                <!-- Section 5: Contribution aux Cibles -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-bullseye"></i>
                        <h3>Contribution à l'Atteinte des Cibles des Actions du FIE</h3>
                    </div>

                    <div class="help-text" style="margin-bottom: 1.5rem;">
                        <i class="fas fa-info-circle"></i>
                        Indiquez les contributions quantitatives de votre projet aux objectifs du FIE
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Cible 1</label>
                        <textarea name="cible_1" class="form-textarea" required 
                                  placeholder="Ex: Reboisement de 50 hectares"></textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Cible 2</label>
                        <textarea name="cible_2" class="form-textarea" 
                                  placeholder="Ex: Formation de 200 agriculteurs"></textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Cible 3</label>
                        <textarea name="cible_3" class="form-textarea" 
                                  placeholder="Ex: Réduction de 30% des émissions de CO2"></textarea>
                    </div>

                    <div class="form-group">
                        <label class="form-label">Cible 4</label>
                        <textarea name="cible_4" class="form-textarea" 
                                  placeholder="Ex: Installation de 100 dispositifs d'économie d'énergie"></textarea>
                    </div>
                </div>

                <!-- Section 6: Visibilité du FIE -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-eye"></i>
                        <h3>Contribution à la Visibilité du FIE</h3>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Comment votre projet contribuera-t-il à la visibilité du FIE ?</label>
                        <textarea name="contribution_visibilite" class="form-textarea large" required 
                                  placeholder="Décrivez les actions de communication, de sensibilisation et de promotion du FIE prévues dans le cadre de votre projet"></textarea>
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            Mentionnez les actions de communication, les événements publics, les supports de communication, etc.
                        </div>
                    </div>
                </div>

                <!-- Section 7: Pièces Jointes -->
                <div class="form-section">
                    <div class="section-header">
                        <i class="fas fa-paperclip"></i>
                        <h3>Pièces Jointes</h3>
                    </div>

                    <div class="form-group">
                        <label class="form-label required">Document du projet complet</label>
                        <input type="file" id="fileInput" name="pieces_jointes[]" class="file-input" 
                               accept=".pdf,.doc,.docx,.xls,.xlsx" multiple required>
                        <div class="file-upload-area" onclick="document.getElementById('fileInput').click()">
                            <i class="fas fa-cloud-upload-alt"></i>
                            <h4>Cliquez pour télécharger vos documents</h4>
                            <p>Formats acceptés: PDF, DOC, DOCX, XLS, XLSX</p>
                            <p style="font-size: 0.9rem; color: #666;">Taille maximale: 10 MB par fichier</p>
                        </div>
                        <div class="file-list" id="fileList"></div>
                        <div class="help-text">
                            <i class="fas fa-info-circle"></i>
                            Vous pouvez télécharger plusieurs documents en les sélectionnant dans votre explorateur de fichiers.
                        </div>
                    </div>
                </div>
                <!-- Form Actions -->
                <div class="form-actions">
                    <button type="button" class="btn btn-secondary" onclick="resetForm()">
                        <i class="fas fa-redo"></i>
                        Réinitialiser
                    </button>
                    <button type="button" class="btn btn-outline" onclick="saveDraft()">
                        <i class="fas fa-save"></i>
                        Enregistrer le brouillon
                    </button>
                    <button type="submit" class="btn btn-primary">
                        <i class="fas fa-paper-plane"></i>
                        Soumettre la demande
                    </button>
                </div>
            </form>
        </div>
    </div>

    <!-- Success Modal -->
    <div class="success-modal" id="successModal">
        <div class="success-content">
            <div class="success-icon">
                <i class="fas fa-check-circle"></i>
            </div>
            <h2>Demande soumise avec succès !</h2>
            <p>Votre demande de financement a été enregistrée.</p>
            <div class="reference-number">
                <i class="fas fa-hashtag"></i> Numéro de référence: <span id="referenceNumber"></span>
            </div>
            <p style="margin-top: 1rem; color: #666;">
                Vous recevrez une confirmation par email dans les prochaines 48 heures.
            </p>
            <button class="btn btn-primary" onclick="closeSuccessModal()" style="margin-top: 1.5rem;">
                <i class="fas fa-home"></i>
                Retour à l'accueil
            </button>
        </div>
    </div>

    <script>
        // Progress tracking
        const form = document.getElementById('fundingForm');
        const progressFill = document.getElementById('progressFill');
        const progressText = document.getElementById('progressText');

        function updateProgress() {
            const inputs = form.querySelectorAll('input[required], textarea[required], select[required]');
            let filled = 0;
            
            inputs.forEach(input => {
                if (input.type === 'checkbox') {
                    const checkboxes = form.querySelectorAll('input[name="guichet[]"]');
                    const anyChecked = Array.from(checkboxes).some(cb => cb.checked);
                    if (anyChecked && !input.dataset.counted) {
                        filled++;
                        input.dataset.counted = true;
                    }
                } else if (input.value.trim() !== '') {
                    filled++;
                }
            });
            
            const percentage = Math.round((filled / inputs.length) * 100);
            progressFill.style.width = percentage + '%';
            progressText.textContent = percentage + '% complété';
        }

        // Add event listeners to all form inputs
        form.addEventListener('input', updateProgress);
        form.addEventListener('change', updateProgress);

        // File upload handling
        const fileInput = document.getElementById('fileInput');
        const fileList = document.getElementById('fileList');
        let uploadedFiles = [];

        fileInput.addEventListener('change', function(e) {
            Array.from(e.target.files).forEach(file => {
                if (file.size > 10 * 1024 * 1024) {
                    alert(`Le fichier ${file.name} dépasse 10 MB`);
                    return;
                }
                
                if (!uploadedFiles.find(f => f.name === file.name)) {
                    uploadedFiles.push(file);
                    addFileToList(file);
                }
            });
            updateProgress();
        });

        function addFileToList(file) {
            const fileItem = document.createElement('div');
            fileItem.className = 'file-item';
            fileItem.innerHTML = `
                <div class="file-item-info">
                    <i class="fas fa-file-${getFileIcon(file.name)}"></i>
                    <span>${file.name} (${(file.size / 1024 / 1024).toFixed(2)} MB)</span>
                </div>
                <button type="button" class="remove-file" onclick="removeFile('${file.name}')">
                    <i class="fas fa-times"></i>
                </button>
            `;
            fileList.appendChild(fileItem);
        }

        function getFileIcon(filename) {
            const ext = filename.split('.').pop().toLowerCase();
            const icons = {
                'pdf': 'pdf',
                'doc': 'word',
                'docx': 'word',
                'xls': 'excel',
                'xlsx': 'excel'
            };
            return icons[ext] || 'alt';
        }

        function removeFile(filename) {
            uploadedFiles = uploadedFiles.filter(f => f.name !== filename);
            const items = fileList.querySelectorAll('.file-item');
            items.forEach(item => {
                if (item.textContent.includes(filename)) {
                    item.remove();
                }
            });
            updateProgress();
        }

        // Form validation and submission
        form.addEventListener('submit', function(e) {
            e.preventDefault();
            
            // Validate required fields
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;
            let firstInvalidField = null;

            requiredFields.forEach(field => {
                if (field.type === 'checkbox') {
                    const checkboxes = form.querySelectorAll('input[name="guichet[]"]');
                    const anyChecked = Array.from(checkboxes).some(cb => cb.checked);
                    if (!anyChecked && !firstInvalidField) {
                        isValid = false;
                        firstInvalidField = field;
                    }
                } else if (!field.value.trim()) {
                    isValid = false;
                    field.style.borderColor = '#dc3545';
                    if (!firstInvalidField) {
                        firstInvalidField = field;
                    }
                } else {
                    field.style.borderColor = '#e9ecef';
                }
            });

            // Check if at least one guichet is selected
            const guichetCheckboxes = form.querySelectorAll('input[name="guichet[]"]');
            const guichetSelected = Array.from(guichetCheckboxes).some(cb => cb.checked);
            
            if (!guichetSelected) {
                isValid = false;
                alert('Veuillez sélectionner au moins un guichet du FIE');
                return;
            }

            // Check if files are uploaded
            if (uploadedFiles.length === 0) {
                isValid = false;
                alert('Veuillez joindre au moins un document de projet');
                return;
            }

            if (!isValid) {
                alert('Veuillez remplir tous les champs obligatoires');
                if (firstInvalidField) {
                    firstInvalidField.scrollIntoView({ behavior: 'smooth', block: 'center' });
                    firstInvalidField.focus();
                }
                return;
            }

            // Collect form data
            const formData = new FormData(form);
            
            // Add files to formData
            uploadedFiles.forEach(file => {
                formData.append('files[]', file);
            });

            // Show success modal
            showSuccessModal();
        });

        function showSuccessModal() {
            const referenceNumber = 'FIE-' + Date.now().toString().slice(-8);
            document.getElementById('referenceNumber').textContent = referenceNumber;
            document.getElementById('successModal').classList.add('show');
            
            // Log form data (in production, this would be sent to server)
            console.log('Demande soumise:', {
                reference: referenceNumber,
                date: new Date().toISOString(),
                files: uploadedFiles.length
            });
        }

        function closeSuccessModal() {
            document.getElementById('successModal').classList.remove('show');
            resetForm();
        }

        // Reset form
        function resetForm() {
            if (confirm('Êtes-vous sûr de vouloir réinitialiser le formulaire ?')) {
                form.reset();
                uploadedFiles = [];
                fileList.innerHTML = '';
                updateProgress();
                
                // Reset checkbox counters
                form.querySelectorAll('input[type="checkbox"]').forEach(cb => {
                    delete cb.dataset.counted;
                });
            }
        }

        // Save draft
        function saveDraft() {
            const formData = {};
            const inputs = form.querySelectorAll('input, textarea, select');
            
            inputs.forEach(input => {
                if (input.type === 'checkbox') {
                    if (!formData[input.name]) {
                        formData[input.name] = [];
                    }
                    if (input.checked) {
                        formData[input.name].push(input.value);
                    }
                } else if (input.type !== 'file') {
                    formData[input.name] = input.value;
                }
            });

            // Save to localStorage
            localStorage.setItem('fie_funding_draft', JSON.stringify(formData));
            
            alert('Brouillon enregistré avec succès ! Vous pouvez revenir plus tard pour terminer votre demande.');
            
            console.log('Brouillon sauvegardé:', formData);
        }

        // Load draft on page load
        window.addEventListener('load', function() {
            const draft = localStorage.getItem('fie_funding_draft');
            
            if (draft) {
                const shouldLoad = confirm('Un brouillon a été trouvé. Voulez-vous le charger ?');
                
                if (shouldLoad) {
                    const formData = JSON.parse(draft);
                    
                    Object.keys(formData).forEach(key => {
                        const input = form.querySelector(`[name="${key}"]`);
                        
                        if (input) {
                            if (input.type === 'checkbox') {
                                const checkboxes = form.querySelectorAll(`[name="${key}"]`);
                                checkboxes.forEach(cb => {
                                    if (formData[key].includes(cb.value)) {
                                        cb.checked = true;
                                    }
                                });
                            } else {
                                input.value = formData[key];
                            }
                        }
                    });
                    
                    updateProgress();
                } else {
                    localStorage.removeItem('fie_funding_draft');
                }
            }
        });

        // Auto-save every 2 minutes
        setInterval(function() {
            const inputs = form.querySelectorAll('input, textarea, select');
            let hasContent = false;
            
            inputs.forEach(input => {
                if (input.value && input.value.trim() !== '') {
                    hasContent = true;
                }
            });
            
            if (hasContent) {
                saveDraft();
                console.log('Auto-sauvegarde effectuée');
            }
        }, 120000); // 2 minutes

        // Validate numeric inputs
        const numericInputs = form.querySelectorAll('input[type="number"]');
        numericInputs.forEach(input => {
            input.addEventListener('input', function() {
                if (this.value < 0) {
                    this.value = 0;
                }
            });
        });

        // Format currency display
        const currencyInputs = document.querySelectorAll('input[name="cout_total"], input[name="montant_sollicite"]');
        currencyInputs.forEach(input => {
            input.addEventListener('blur', function() {
                if (this.value) {
                    const formatted = parseFloat(this.value).toLocaleString('fr-FR');
                    const label = this.parentElement.querySelector('.form-label');
                    if (label && !label.querySelector('.formatted-value')) {
                        const span = document.createElement('span');
                        span.className = 'formatted-value';
                        span.style.cssText = 'color: #2e8b57; font-weight: normal; margin-left: 0.5rem;';
                        span.textContent = `(${formatted} FCFA)`;
                        label.appendChild(span);
                    }
                }
            });
        });

        // Initialize progress on load
        updateProgress();

        // Smooth scroll to top button
        window.addEventListener('scroll', function() {
            const scrollBtn = document.getElementById('scrollTopBtn');
            if (!scrollBtn) {
                const btn = document.createElement('button');
                btn.id = 'scrollTopBtn';
                btn.innerHTML = '<i class="fas fa-arrow-up"></i>';
                btn.style.cssText = `
                    position: fixed;
                    bottom: 2rem;
                    right: 2rem;
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    background: linear-gradient(135deg, #2e8b57, #228b22);
                    color: white;
                    border: none;
                    cursor: pointer;
                    display: none;
                    align-items: center;
                    justify-content: center;
                    font-size: 1.2rem;
                    box-shadow: 0 4px 15px rgba(46, 139, 87, 0.3);
                    transition: all 0.3s ease;
                    z-index: 1000;
                `;
                btn.addEventListener('click', function() {
                    window.scrollTo({ top: 0, behavior: 'smooth' });
                });
                document.body.appendChild(btn);
            }
            
            const scrollTopBtn = document.getElementById('scrollTopBtn');
            if (window.pageYOffset > 300) {
                scrollTopBtn.style.display = 'flex';
            } else {
                scrollTopBtn.style.display = 'none';
            }
        });
    </script>
</body>
</html>
